#include "mylist.h"
#include <iostream>
#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <assert.h>

using namespace std;
class CItem{
public:
	int data;
	CItem* next;
	CItem(){};
	CItem( int info ){
		data = info;
		next = 0;
	}
};
CMyList::CMyList( int data ){
	head = new CItem( data );
}
CMyList::CMyList(){
	head = 0;
}
CMyList::~CMyList(){
	while( head != 0 )
		Pop();
}
CMyList::CMyList( const CMyList& other){
     head = 0;
     (*this) = other;
}
CMyList& CMyList::operator= (const CMyList& other){
	while( head != 0 )
		Pop();
	if( other.GetCount() == 0 ) return *this;
	head = new CItem( other[0] );
	CItem* tmp = head;
	int size = other.GetCount();
	for( int i = 1; i < size; i++ ){
		tmp->next = new CItem( other[i] );
		tmp = tmp->next; 
	}
	return *this;
}
void CMyList::Push( int data ){
	CItem* tmp = new CItem( data );
	tmp->next = head;
	head = tmp;
}
int CMyList::Pop(){
	assert( head != 0 );
	CItem* tmp = head;
	head = head->next;
	int data = tmp->data;
	return data;
}
int CMyList::GetCount() const{
	CItem* tmp = head;
	int count = 0;
	while(tmp != 0){
		tmp = tmp->next;
		count++;
	}
	return count;
}
void CMyList::InsertItem( int index, int data ){
	assert( index >= 0 && index <= GetCount() );
	CItem* tmp = head;
	if( index == 0 ){
		Push( data );
	}else{
		for( int i = 0; i < index - 1; i++, tmp = tmp->next );
		CItem* p = new CItem( data );
		p->next = tmp->next;
		tmp->next = p;
	}
}
void CMyList::RemoveItem( int index ){
	assert( index >= 0 && index < GetCount() );
	CItem* tmp = head;
	CItem* prev = head;
	for( int i = 0; i < index; i++ ){
		tmp = tmp->next;
		if( i !=0 ) prev = prev->next;
	}
	if( index == 0 ){
		head = head->next;
	}else{
		prev->next = tmp->next;
	}
}
const int& CMyList::operator []( int index ) const{
	assert( index >= 0 && index < GetCount());
	CItem* tmp = head;
	for( int i = 0; i < index; i++ )
		tmp = tmp->next;
	return tmp->data;
}
int& CMyList::operator []( int index ) {
	assert( index >= 0 && index < GetCount());
	CItem* tmp = head;
	for( int i = 0; i < index; i++ )
		tmp = tmp->next;
	return tmp->data;
}
int CMyList::FindFirst( int data, int from ) const{
	assert( from < GetCount() );
	CItem* tmp = head;
	int size = GetCount();
	assert( from < size );
	for( int i = 0; i < from; i++ )
		tmp = tmp->next;
	for( int i = 0; i < size - from; i++ ){
		if ( tmp->data == data ) return i + from;
		tmp = tmp->next;
	}
	return -1;
}
bool CMyList::operator == ( CMyList& other ) const {
	if ( GetCount() != other.GetCount() ) return false;
	CItem* tmp = head;
	CItem* tmp2 = other.head;
	while( tmp != 0 && tmp2 != 0 ){
		if ( tmp->data != tmp2->data ) return false;
		tmp = tmp->next;
		tmp2 = tmp2->next;
	}
	return true;
}
void CMyList::PrintList() const{
	CItem* tmp = head;
	for( int i = 0; i < GetCount(); i++ ){
		cout<<tmp->data<<endl;
		tmp = tmp->next;
	}
}
bool CMyList::IsSortedSet() const {
	CItem* tmp = head;
	for( int i = 0; i < GetCount() - 1; i++){
		if (tmp->data >= tmp->next->data) return false;
		tmp = tmp->next;
	}
	return true;
}
void CMyList::AddRandomItems( int count, int a, int b ){
	assert( count > 0 && a <= b );
	for( int i = 0; i < count; i++)
		Push( rand() % (b - a) + a );
}
int CMyList::GetItemsCount( int data ) const{
	int count = 0;
	CItem* tmp = head;
	for( int i = 0; i < GetCount(); i++ ){
		if( tmp->data == data ) count++;
		tmp = tmp->next;
	}
	return count;
}
CMyList CMyList::operator& ( const CMyList& other ) const{
	assert( IsSortedSet() && other.IsSortedSet() );
	CMyList p;
	int size = other.GetCount();
	for( int i = 0; i < size; i++ )
		if( GetItemsCount( other[i] ) != 0 ) p.Push( other[i] );
	p.Sort();
	return p;
}
CMyList CMyList::operator| ( const CMyList& other ) const{
	assert( IsSortedSet() && other.IsSortedSet() );
	CMyList p;
	int size_this = GetCount();
	for( int i = 0; i < size_this; i++ )
		p.Push( (*this)[i] );
	int size = other.GetCount();
	for( int i = 0; i < size; i++ )
		if( GetItemsCount( other[i] ) == 0 ) p.Push( other[i] );
	p.Sort();
	return p;
}
CMyList CMyList::operator- ( const CMyList& other ) const{
	assert( IsSortedSet() && other.IsSortedSet() );
	CMyList p;
	int size = GetCount();
	for( int i = 0; i < size; i++ )
		if( other.GetItemsCount( (*this)[i] ) == 0 ) p.Push( (*this)[i] );
	p.Sort();
	return p;
}
CMyList CMyList::operator^ ( const CMyList& other ) const{
	assert( IsSortedSet() && other.IsSortedSet() );
	CMyList p;
	int size = other.GetCount();
	for( int i = 0; i < size; i++ )
		if( GetItemsCount( other[i] ) == 0 ) p.Push( other[i] );
	int size_this = GetCount();
	for( int i = 0; i < size_this; i++ )
		if( other.GetItemsCount( (*this)[i] ) == 0 ) p.Push( (*this)[i] );
	p.Sort();
	return p;
}
void CMyList::Sort(){
	int size = GetCount();
	for(int i = 0; i < size - 1; i++ )
		for(int j = i + 1; j < size; j++ )
			if( (*this)[i] > (*this)[j] )
				swap( (*this)[i], (*this)[j] );
}


