#include <iostream>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <stdlib.h>
using namespace std;
const int ExprLenght = 256;

void GetExprFromFile( const char* filename, char* exp ){
	FILE* fin = fopen( filename, "r" );
	fgets( exp, ExprLenght, fin ); 
	fclose( fin );
}
int GetRightBracePosition( int LBrace, char* exp ){
	int balance = 1;
	int result = 0;
	for( int i = LBrace + 1; balance != 0; i++ ){
		if( exp[i] == '(' ){
			balance++;
		}else if( exp[i] == ')' ){
			balance--;
		}
		result = i;
	}
	return result;
}
int GetLeftBracePosition( int RBrace, char* exp ){
	int balance = 1;
	int result = 0;
	for( int i = RBrace - 1; balance != 0; i-- ){
		if( exp[i] == ')' ){
			balance++;
		}else if( exp[i] == '(' ){
			balance--;
		}
		result = i;
	}
	return result;
}
bool IsDigit( int L, int R, char* exp ){
	if( exp[L] != '-' && exp[L] != '+' && !isdigit(exp[L]) ){
		return false;
	}
	for( int i = L + 1; i <= R; i++ ){
		if( !isdigit( exp[i] ) ) return false;
	}
	return true;
}

int AtoI( int L, int R, char* exp ){
	int result = 0;
	int sign = 1;
	if( exp[L] == '-' ){
		sign = -1;
		L++;
	}
	int digit_pos = 0;
	for( int i = R; i >= L; i-- ){
		result += (exp[i] - '0') * pow( 10, digit_pos );
		digit_pos++;
	}
	//  cout<<" RES = "<< result * sign;
	return result * sign;

}
bool IsOperationSign( int pos, char* exp ){
	if( pos > 0 ){
		if( isdigit( exp[pos - 1] ) || exp[pos - 1] == ')' ){
			return true;
		}
	}
	return false;
}
void BraceReduce( int& from, int& to, char* exp ){
	while( exp[to] == ')' && GetLeftBracePosition( to, exp ) == from ){
		from++;
		to--;
	}
}
void BraceJump( int from, int to, int& pos, char* exp ){
	if( exp[pos] == ')' ){
		pos = GetLeftBracePosition( pos, exp );
	}
}
int Calc( int from, int to, char* exp ){
	BraceReduce( from, to, exp );
	if( IsDigit( from, to, exp ) ){
		return AtoI( from, to, exp );
	}
	for(int power = 0; power < 2; power++ ){
		for( int i = to; i >= from; i-- ){
			BraceJump( from, to, i, exp );
			switch( power ){
			case 0:
				if( IsOperationSign( i, exp ) ){
					switch( exp[i] ){
			case '+':
				return Calc( from, i - 1, exp ) + Calc( i + 1, to, exp );
			case '-':
				return Calc( from, i - 1, exp ) - Calc( i + 1 , to, exp );
					}
				};
				break;
			case 1:
				switch( exp[i] ){
			case '*':
				return Calc( from, i - 1, exp ) * Calc( i + 1, to, exp );
			case '/':
				if(  Calc( i + 1, to, exp ) == 0 ){
					return 0;
				}else{
					return Calc( from, i - 1, exp ) / Calc( i + 1, to, exp );
				};
				}
				break;
			}
		}
	}
}
int LastDig( char* exp ){
	int i = 0;
	while( exp[i] ){
		i++;
	}
	return i-1;
}
int main(){
	char* exp = new char[ExprLenght];
	GetExprFromFile( "input.txt", exp );
	cout<< Calc( 0, LastDig( exp ), exp );
	return 0;
}