#include <iostream>
#include <stdio.h>
#include <math.h>
using namespace std;
const long int machine_infinity = 2147483646;
typedef int ** TMatrix;

int main(void)
{
	int n;
	int min;
	long int *cur_weight;
	int	*IsVisited, *Father;
	TMatrix matr = NULL;
	FILE * file;

	if((file = fopen("input.txt","r")) == NULL)
		return 1;
	fscanf(file, "%d", &n);

	matr = new int * [n];

	for(int i = 0; i < n; i++)
		matr[i] = new int[n];

	for(int i = 0; i < n; i++)
		for(int j = 0;j < n; j++)
		{
			fscanf(file, "%d", &matr[i][j]);
		}

	fclose(file);

	cur_weight = new long int [n];
	IsVisited = new int[n];
	Father = new int [n];

	for(int i=0;i<n; i++)
	{
		cur_weight[i]=0;
		IsVisited[i]=0;
		Father[i]=0;
	}

	for(int i=0;i<n;i++)
		cur_weight[i]=machine_infinity;

	int u=0;
	bool change=false;
	IsVisited[0]=1;
	cur_weight[0]=0;
	//cycle of infinity
	for(;;)
	{
		for (int j=0; j<n;j++)
			if(matr[u][j]!=-1 && cur_weight[j]>cur_weight[u]+matr[u][j])
			{
				IsVisited[j]=1;
				cur_weight[j]=cur_weight[u]+matr[u][j];
				Father[j]=u;
			}

		min=machine_infinity;
		IsVisited[u]=0;
		change=false;

		//finding of min visited point
		for(int i=0;i<n;i++)
			if (cur_weight[i]<min && IsVisited[i]==1)
			{
				min=cur_weight[i];
				u=i;
				change=true;
			}
		if (change==false) break;
	}

	// Writing groups to file
	if((file = fopen("output.txt","w"))	== NULL)
		return 2;

	for(int i=1;i<n;i++)
		fprintf(file, "%d ", cur_weight[i]);

	fprintf(file, "\n");

	for(int i=1;i<n;i++)
		fprintf(file, "%d ", Father[i]);

	fclose(file);
	// Destroying matrice and massives
	for(int i = 0; i < n; i++)
		delete [] matr[i];
	delete [] matr;
	delete [] Father;
	delete [] cur_weight;
	delete [] IsVisited;
	matr =  NULL;
	Father = IsVisited = NULL;
	cur_weight=NULL;
	return 0;
}