#include ".\complex.h"
#include <stdio.h>
#include <assert.h>

Complex::Complex (int c1, int m1)
{
	c=c1;m=m1;
	//cout<<"K-1 , CREATED COMPLEX NUMBER: "<<c1<<"+"<<m1<<"i"<<endl;
}
Complex::Complex (const Complex &other)
{
	c=other.c;m=other.m;
	//cout<<"K-2 , COPIED COMPLEX NUMBER: "<<c<<"+"<<m<<"i"<<endl;
}
Complex::~Complex ()
{
	//cout<<"D-1 , DELETED COMPLEX NUMBER: "<<c<<"+"<<m<<"i"<<endl;
}
bool Complex::operator == (const Complex& other)
{
	return ((other.c==c) && (other.m==m)) ;
}
bool Complex::operator == (int &c1)
{
	return ((c==c1) && (m==0));
}
bool Complex::operator != (const Complex& other)
{
	return (((other.c!=c) || (other.m!=m))) ;
}
bool Complex::operator != (int &c1)
{
	return (c!=c1)  ;
}
bool Complex::operator > (const Complex& other)
{
	return ((c==other.c) && (m>other.m)) || (c>other.c) ;
}
bool Complex::operator < (const Complex& other)
{
	return (((c==other.c) && (m<other.m)) || (c<other.c));
}
Complex Complex :: operator = (Complex other)
{
	c=other.c;m=other.m;
	return *this;
}
Complex Complex :: operator = (int other)
{
	c=other;m=0;
	return *this;
}
Complex Complex::operator + (Complex other)
{
	Complex otvet;
	otvet.c=c+other.c;
	otvet.m=m+other.m;
	return otvet;
}
Complex Complex::operator - (Complex other)
{
	Complex otvet;
	otvet.c=c-other.c;
	otvet.m=m-other.m;
	return otvet;
}
Complex Complex::operator * (Complex other)
{
	Complex otvet;
	otvet.c=c*m-other.c*other.m;
	otvet.m=c*other.m+other.c*m;
	return *this;
}
Complex Complex::operator += (Complex other)
{
	c=c+other.c;
	m=m+other.m;
	return *this;
}
Complex Complex::operator -= (Complex other)
{
	c=c-other.c;
	m=m-other.m;
	return *this;
}
Complex Complex::operator ++ ()
{
	c=c++;
	return *this;
}
void Complex::SetReal(int real)
{
	c=real;
}
void Complex::SetMnim(int mnim)
{
	m=mnim;
}

ostream &operator <<( ostream& out,  const Complex &compl )
{
	if (compl.GetMnim()>0) {out<<compl.GetReal()<<"+"<<compl.GetMnim()<<"i ";}
	else if (compl.GetMnim()<0) {out<<compl.GetReal()<<compl.GetMnim()<<"i ";}
	else {out<<compl.GetReal();}
	return out;
}
istream& operator>>( istream& in, Complex &compl )
{
	char tmpStr[100];
	printf("Format of input - a;b where a - Real part, b - Mnim \n");
	in>>tmpStr;
	int Real;
	int Mnim;
	sscanf( tmpStr, "%d;%d", &Real, &Mnim );
	compl.SetReal(Real);
	compl.SetMnim(Mnim);
	return in;
}